using System;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace ECFSweda
{

	public class Sweda
	{	


		#region Funes de tratamento de erro
		
			/// <summary>
		/// Funo para analizar os retorno da impressora (ST1 e ST2).
		/// </summary>
			public static void Analisa_RetornoImpressora()
			{
				int ACK,ST1,ST2;
				string Erros = "";
				ACK = ST1 = ST2 =0;

				ECF_RetornoImpressora(ref ACK,ref ST1,ref ST2);

				#region Tratando o ST1
				if ( ST1 >= 128)
				{
					ST1 = ST1 - 128;
					Erros += "BIT 7 - Fim de Papel" + '\x0D';				
				}
				if ( ST1 >= 64)
				{
					ST1 = ST1 - 64;
					Erros += "BIT 6 - Pouco Papel" + '\x0D';
				}
				if ( ST1 >= 32)
				{
					ST1 = ST1 - 32;
					Erros += "BIT 5 - Erro no Relgio" + '\x0D';
				}
				if ( ST1 >= 16)
				{
					ST1 = ST1 - 16;
					Erros += "BIT 4 - Impressora em ERRO" + '\x0D';
				}
				if ( ST1 >= 8)
				{
					ST1 = ST1 - 8;
					Erros += "BIT 3 - CMD no iniciado com ESC" + '\x0D';
				}
				if ( ST1 >= 4)
				{
					ST1 = ST1 - 4;
					Erros += "BIT 2 - Comando Inexistente" + '\x0D';
				}
				if ( ST1 >= 2)
				{
					ST1 = ST1 - 2;
					Erros += "BIT 1 - Cupom Aberto" + '\x0D';
				}
				if ( ST1 >= 1)
				{
					ST1 = ST1 - 1;
					Erros += "BIT 0 - N de Parmetros Invlidos" + '\x0D';
				}
				#endregion

				#region Tratando o ST2
				if ( ST2 >= 128)
				{
					ST2 = ST2 - 128;
					Erros += "BIT 7 - Tipo de Parmetro Invlido" + '\x0D';
				}
				if ( ST2 >= 64)
				{
					ST2 = ST2 - 64;
					Erros += "BIT 6 - Memria Fiscal Lotada" + '\x0D';
				}
				if ( ST2 >= 32)
				{
					ST2 = ST2 - 32;
					Erros += "BIT 5 - CMOS no Voltil" + '\x0D';
				}
				if ( ST2 >= 16)
				{
					ST2 = ST2 - 16;
					Erros += "BIT 4 - Alquota No Programada" + '\x0D';
				}
				if ( ST2 >= 8)
				{
					ST2 = ST2 - 8;
					Erros += "BIT 3 - Alquotas lotadas" + '\x0D';
				}
				if ( ST2 >= 4)
				{
					ST2 = ST2 - 4;
					Erros += "BIT 2 - Cancelamento  Permitido" + '\x0D';
				}
				if ( ST2 >= 2)
				{
					ST2 = ST2 - 2;
					Erros += "BIT 1 - CGC/IE no Programados" + '\x0D';
				}
				if ( ST2 >= 1)
				{
					ST2 = ST2 - 1;
					Erros += "BIT 0 - Comando no Executado" + '\x0D';
				}

				#endregion
				
				if (Erros.Length != 0)
					System.Windows.Forms.MessageBox.Show(Erros,"Erro na Execuo do Comando",MessageBoxButtons.OK,MessageBoxIcon.Error);					
			}

			/// <summary>
		/// Funo que analiza o retorno da funo.
		/// </summary>
		/// <param name="IRetorno">Inteiro com o valor a ser analizado.</param>
			public static void Analisa_iRetorno(int IRetorno)
			{
				string MSG = "";
				string MSGCaption = "Ateno";
				MessageBoxIcon MSGIco = MessageBoxIcon.Information;

				switch(IRetorno)
				{
					case  0: 
						MSG = "Erro de Comunicao !";
						MSGCaption = "Erro";
						MSGIco = MessageBoxIcon.Error;
						break;
					case -1: 
						MSG = "Erro de Execuo na Funo. Verifique!";
						MSGCaption = "Erro";
						MSGIco = MessageBoxIcon.Error;
						break;
					case -2: 
						MSG = "Parmetro Invlido !";
						MSGCaption = "Erro";
						MSGIco = MessageBoxIcon.Error;
						break;
					case -3: 
						MSG = "Alquota no programada !";
						break;
					case -4: 
						MSG = "Arquivo BemaFI32.INI no encontrado. Verifique!";
						break;
					case -5: 
						MSG = "Erro ao Abrir a Porta de Comunicao";
						MSGCaption = "Erro";
						MSGIco = MessageBoxIcon.Error;
						break;
					case -6: 
						MSG = "Impressora Desligada ou Desconectada.";
						break;
					case -7: 
						MSG = "Banco No Cadastrado no Arquivo BemaFI32.ini";
						break;
					case -8: 
						MSG = "Erro ao Criar ou Gravar no Arquivo Retorno.txt ou Status.txt.";
						MSGCaption = "Erro";
						MSGIco = MessageBoxIcon.Error;
						break;
					case -18: 
						MSG = "No foi possvel abrir arquivo INTPOS.001!";
						break;
					case -19: 
						MSG = "Parmetros diferentes!";
						break;
					case -20: 
						MSG = "Transao cancelada pelo Operador!";
						break;
					case -21: 
						MSG = "A Transao no foi aprovada!";
						break;
					case -22: 
						MSG = "No foi possvel terminar a Impresso!";
						break;
					case -23: MSG = "No foi possvel terminar a Operao!";
						break;
					case -24: MSG = "No foi possvel terminal a Operao!";
						break;
					case -25: MSG = "Totalizador no fiscal no programado.";
						break;
					case -26: MSG = "Transao j Efetuada!";
						break;
					case -27: Analisa_RetornoImpressora();
						break;
					case -28: MSG = "No h Informaes para serem Impressas!";
						break;
				}
				if (MSG.Length != 0)
					System.Windows.Forms.MessageBox.Show(MSG,MSGCaption,MessageBoxButtons.OK,MSGIco);

			}

		
		#endregion

		#region IMPORT DAS FUNES DA CONVECF.DLL
		/*
		 ===============================================================================
			********************************************************************************

								DECLARAO DAS FUNES DA CONVECF.DLL
  
			********************************************************************************
		 ===============================================================================
		*/


		#region Funes de Inicializao
		/// <summary>
		/// Altera o smbolo da moeda programada na Impressora Fiscal. 
		/// </summary>
		/// <param name="SimboloMoeda">STRING contendo o smbolo da moeda. O $ (cifro)  inserido automaticamente.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AlteraSimboloMoeda(string SimboloMoeda );
		/// <summary>
		/// Programa alquota tributria na Impressora Fiscal. 
		/// </summary>
		/// <param name="Aliquota">STRING com o valor da alquota a ser programada</param>
		/// <param name="ICMS_ISS">INTEIRO com o valor 0 (zero) para vincular a alquota ao ICMS e 1 (um) para vincular ao ISS</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ProgramaAliquota(string Aliquota, int ICMS_ISS);
		/// <summary>
		/// Programa departamento na impressora.
		/// </summary>
		/// <param name="Indice">INTEIRO com a posio em que o Departamento ser cadastrado. </param>
		/// <param name="Departamento">STRING com at 10 caracteres com o nome do departamento. </param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NomeiaDepartamento(int Indice, string Departamento);
		/// <summary>
		/// Programa Totalizador No Sujeito ao ICMS. 
		/// </summary>
		/// <param name="Indice">INTEIRO com a posio em que o totalizador ser programado. </param>
		/// <param name="Totalizador">STRING at 19 caracteres com o nome do totalizador.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NomeiaTotalizadorNaoSujeitoIcms(int Indice, string Totalizador);
		/// <summary>
		/// Programa o espaamento de linhas entre os cupons.
		/// </summary>
		/// <param name="Linhas">INTEIRO entre 0 e 255 indicando o nmero de linhas. O valor default da impressora  8 linhas.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_LinhasEntreCupons(int Linhas);
		/// <summary>
		/// Programa o espaamento entre as linhas impressas no cupom
		/// </summary>
		/// <param name="Dots">INTEIRO entre 0 e 255 indicando o espao (dots) entre as linhas. O valor default da impressora  0.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_EspacoEntreLinhas(int Dots);
		/// <summary>
		/// Permite tornar a impresso mais forte nos equipamentos baseados na MP-20 FI II.
		/// </summary>
		/// <param name="ForcaImpacto">INTEIRO com o valor da fora de impacto das agulhas que pode ser: 
		///			<br>1  Impacto fraco (default) </br>
		///			<br>2  Impacto mdio </br> 
		///			<br>3  Impacto forte </br></param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ForcaImpactoAgulhas(int ForcaImpacto);
		/// <summary>
		/// Programa e desprograma o horrio de vero. Se a impressora j estiver no horrio de vero o mesmo ser desprogramado atrasando o relgio em 1 (uma) hora, caso contrrio ser adiantado 1 (uma) hora.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ProgramaHorarioVerao();
		/// <summary>
		/// Programa o modo arrendondamento na impressora. Este arredondamento se refere  venda de item com quantidade fracionria.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ProgramaArredondamento();
		/// <summary>
		/// Programa o modo truncamento na impressora.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ProgramaTruncamento();
		#endregion
		
		#region Funes do Cupom Fiscal
		/// <summary>
		/// Abre o cupom fiscal na impressora.
		/// </summary>
		/// <param name="CGC_CPF">STRING at 29 caracteres com o CNPJ ou CPF do cliente.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AbreCupom(string CGC_CPF);
		/// <summary>
		/// Vende item aps a abertura do cupom fiscal. Essa funo permite tambm a venda de itens com 3 casas decimais no valor unitrio.
		/// </summary>
		/// <param name="Codigo">STRING at 13 caracteres com o cdigo do produto.</param>
		/// <param name="Descricao">STRING at 29 caracteres com a descrio do produto.</param>
		/// <param name="Aliquota">STRING com o valor ou o ndice da alquota tributria. Se for o valor deve ser informado com o tamanho de 4 caracteres ou 5 com a vrgula. Se for o ndice da alquota deve ser 2 caracteres. Ex. (18,00 para o valor ou 05 para o ndice).</param>
		/// <param name="TipoQuantidade">1 (um) caracter indicando o tipo de quantidade. I - Inteira e F - Fracionria.</param>
		/// <param name="Quantidade">STRING com at 4 dgitos para quantidade inteira e 7 dgitos para quantidade fracionria. Na quantidade fracionria so 3 casas decimais.</param>
		/// <param name="CasasDecimais">INTEIRO indicando o nmero de casas decimais para o valor unitrio (2 ou 3).</param>
		/// <param name="ValorUnitario">STRING at 8 dgitos para valor unitrio.</param>
		/// <param name="TipoDesconto">1 (um) caracter indicando a forma do desconto. '$' desconto por valor e '%' desconto percentual</param>
		/// <param name="Desconto">String com at 8 dgitos para desconto por valor (2 casas decimais) e 4 dgitos para desconto percentual.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VendeItem(string Codigo, string Descricao, string Aliquota, string TipoQuantidade, string Quantidade, int CasasDecimais, string ValorUnitario, string TipoDesconto, string Desconto);
		/// <summary>
		/// Essa funo permite a venda de itens com entrada de departamento, desconto e unidade de medida.
		/// </summary>
		/// <param name="Codigo">STRING at 49 caracteres com o cdigo do produto.</param>
		/// <param name="Descricao">STRING at 201 caracteres com a descrio do produto.</param>
		/// <param name="Aliquota">STRING com o valor ou o ndice da alquota tributria. Se for o valor deve ser informado com o tamanho de 4 caracteres ou 5 com a vrgula. Se for o ndice da alquota deve ser 2 caracteres. Ex. (18,00 para o valor ou 05 para o ndice)</param>
		/// <param name="ValorUnitario">STRING com at 9 dgitos para o valor (tres casas decimais).</param>
		/// <param name="Quantidade"> STRING com at 7 dgitos para a quantidade. Na venda com departamento a quantidade  fracionria e so 3 casas decimais.</param>
		/// <param name="Acrescimo">STRING com o acrscimo por valor com at 10 dgitos (2 casas decimais).</param>
		/// <param name="Desconto">STRING com o desconto por valor com at 10 dgitos (2 casas decimais).</param>
		/// <param name="IndiceDepartamento">STRING com o ndice do departamento com 2 dgitos.</param>
		/// <param name="UnidadeMedida">STRING com no mximo 2 caracteres para a unidade de medida. Caso no seja passado nenhum caracter a unidade no  impressa.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VendeItemDepartamento(string Codigo, string Descricao, string Aliquota, string ValorUnitario, string Quantidade, string Acrescimo, string Desconto, string IndiceDepartamento, string UnidadeMedida);
		/// <summary>
		/// Cancela o ltimo item vendido.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CancelaItemAnterior();
		/// <summary>
		/// Cancela qualquer item dentre os cem (100) ltimos itens vendidos.
		/// </summary>
		/// <param name="NumeroItem">STRING com o nmero do item a ser cancelado com no mximo 3 dgitos.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CancelaItemGenerico(string NumeroItem);
		/// <summary>
		/// Cancela o ltimo cupom emitido.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CancelaCupom();
		/// <summary>
		/// Permite fechar o cupom de forma resumida, ou seja, sem acrscimo ou desconto no cupom e com apenas uma forma de pagamento. Essa funo l o subtotal do cupom para fecha-lo.
		/// </summary>
		/// <param name="FormaPagamento">STRING com a forma de pagamento com no mximo 16 caracteres.</param>
		/// <param name="Mensagem">STRING com a mensagem promocional com at 384 caracteres (8 linhas X 48 colunas), para a impressora fiscal MP-20 FI II, e 320 caracteres (8 linhas X 40 colunas), para a impressora fiscal MP-40 FI II.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_FechaCupomResumido(string FormaPagamento, string Mensagem);
		/// <summary>
		/// Fecha o cupom fiscal com a impresso da mensagem promocional.
		/// </summary>
		/// <param name="FormaPagamento">STRING com o nome da forma de pagamento com no mximo 16 caracteres.</param>
		/// <param name="AcrescimoDesconto">Indica se haver acrscimo ou desconto no cupom. 'A' para acrscimo e 'D' para desconto.</param>
		/// <param name="TipoAcrescimoDesconto">Indica se o acrscimo ou desconto  por valor ou por percentual. '$' para desconto por valor e '%' para percentual.</param>
		/// <param name="ValorAcrescimoDesconto">STRING com no mximo 14 dgitos para acrscimo ou desconto por valor e 4 dgitos para acrscimo ou desconto por percentual.</param>
		/// <param name="ValorPago">STRING com o valor pago com no mximo 14 dgitos.</param>
		/// <param name="Mensagem">STRING com a mensagem promocional com at 384 caracteres (8 linhas X 48 colunas), para a impressora fiscal MP-20 FI II, e 320 caracteres (8 linhas X 40 colunas), para a impressora fiscal MP-40 FI II.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_FechaCupom(string FormaPagamento, string AcrescimoDesconto, string TipoAcrescimoDesconto, string ValorAcrescimoDesconto, string ValorPago, string Mensagem);
		/// <summary>
		/// Inicia o fechamento do cupom com o uso das formas de pagamento.
		/// </summary>
		/// <param name="AcrescimoDesconto">Indica se haver acrscimo ou desconto no cupom. 'A' para acrscimo e 'D' para desconto.</param>
		/// <param name="TipoAcrescimoDesconto">Indica se o acrscimo ou desconto  por valor ou por percentual. '$' para desconto por valor e '%' para percentual.</param>
		/// <param name="ValorAcrescimoDesconto">STRING com no mximo 14 dgitos para acrscimo ou desconto por valor e 4 dgitos para acrscimo ou desconto por percentual.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_IniciaFechamentoCupom(string AcrescimoDesconto, string TipoAcrescimoDesconto, string ValorAcrescimoDesconto);
		/// <summary>
		/// Imprime a(s) forma(s) de pagamento e o(s) valor(es) pago(s) nessa forma.
		/// </summary>
		/// <param name="FormaPagamento">STRING com a forma de pagamento com no mximo 16 caracteres.</param>
		/// <param name="ValorFormaPagamento">STRING com o valor da forma de pagamento com at 14 dgitos.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_EfetuaFormaPagamento(string FormaPagamento, string ValorFormaPagamento);
		/// <summary>
		/// Imprime a(s) forma(s) de pagamento e o(s) valor(es) pago(s). Permite a impresso de comentrios na(s) forma(s) de pagamento.
		/// </summary>
		/// <param name="FormaPagamento">STRING com a forma de pagamento com no mximo 16 caracteres.</param>
		/// <param name="ValorFormaPagamento">STRING com o valor da forma de pagamento com at 14 dgitos.</param>
		/// <param name="Descricao">STRING com a descrio da forma de pagamento com no mximo 80 caracteres.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_EfetuaFormaPagamentoDescricaoForma(string FormaPagamento, string ValorFormaPagamento, string Descricao);
		/// <summary>
		/// Termina o fechamento do cupom com mensagem promocional.
		/// </summary>
		/// <param name="Mensagem">STRING com a mensagem promocional com at 384 caracteres (8 linhas X 48 colunas), para a impressora fiscal MP-20 FI II, e 320 caracteres (8 linhas X 40 colunas), para a impressora fiscal MP-40 FI II.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_TerminaFechamentoCupom(string Mensagem);
		/// <summary>
		/// Permite estornar valores de uma forma de pagamento e inserir em outra.
		/// </summary>
		/// <param name="FormaOrigem">STRING com a forma de pagamento de onde o valor ser estornado, com at 16 caracteres.</param>
		/// <param name="FormaDestino">STRING com a forma de pagamento onde o valor ser inserido, com at 16 caracteres.</param>
		/// <param name="Valor"> STRING com o valor a ser estornado com at 14 dgitos. No pode ser maior que o total da forma de pagamento de origem.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_EstornoFormasPagamento(string FormaOrigem, string FormaDestino, string Valor);
		/// <summary>
		/// Esta funo permite aumentar a descrio do item at 200 caracteres.
		/// </summary>
		/// <param name="Descricao">STRING com a descrio do item com at 200 caracteres.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AumentaDescricaoItem(string Descricao);
		/// <summary>
		/// Imprime a unidade de medida aps a quantidade do produto na venda de item.
		/// </summary>
		/// <param name="UnidadeMedida">STRING com a unidade de medida at 2 caracteres.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_UsaUnidadeMedida(string UnidadeMedida);
		#endregion
				
		#region Funes dos Relatrios Fiscais
		/// <summary>
		/// Emite a Leitura X na impressora.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_LeituraX();
		/// <summary>
		/// Recebe os dados da Leitura X pela serial e grava em arquivo texto.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_LeituraXSerial();
		/// <summary>
		/// Emite a Reduo Z na impressora. Permite ajustar o relgio interno da impressora em at 5 minutos.
		/// </summary>
		/// <param name="Data">STRING com a Data atual da impressora no formato ddmmaa ou dd/mm/aa, dd/mm/aaaa ou dd/mm/aa.</param>
		/// <param name="Hora">STRING com a Hora a ser alterada no formato hhmmss ou hh:mm:ss.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ReducaoZ(string Data, string Hora);
		/// <summary>
		/// 
		/// </summary>
		/// <param name="Texto"></param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_RelatorioGerencial(string Texto);
		/// <summary>
		/// 
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_FechaRelatorioGerencial();
		/// <summary>
		/// Emite a leitura da memria fiscal da impressora por intervalo de datas.
		/// </summary>
		/// <param name="DataInicial">STRING com a Data inicial no formato ddmmaa, dd/mm/aa, ddmmaaaa ou dd/mm/aaaa.</param>
		/// <param name="DataFinal">STRING com a Data final no formato ddmmaa, dd/mm/aa, ddmmaaaa ou dd/mm/aaaa.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_LeituraMemoriaFiscalData(string DataInicial,string DataFinal);
		/// <summary>
		/// Emite a leitura da memria fiscal da impressora por intervalo de redues.
		/// </summary>
		/// <param name="ReducaoInicial">STRING com o Nmero da reduo inicial com at 4 dgitos.</param>
		/// <param name="ReducaoFinal">STRING com o Nmero da reduo final com at 4 dgitos.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_LeituraMemoriaFiscalReducao(string ReducaoInicial, string ReducaoFinal);
		/// <summary>
		/// Recebe os dados da memria fiscal por intervalo de datas pela serial e grava em arquivo texto.
		/// </summary>
		/// <param name="DataInicial">STRING com a Data inicial no formato ddmmaa, dd/mm/aa, ddmmaaaa ou dd/mm/aaaa.</param>
		/// <param name="DataFinal">STRING com a Data final no formato ddmmaa, dd/mm/aa, ddmmaaaa ou dd/mm/aaaa.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_LeituraMemoriaFiscalSerialData(string DataInicial, string DataFinal);
		/// <summary>
		/// Recebe os dados da leitura da memria fiscal por intervalo de redues pela serial e grava em arquivo texto.
		/// </summary>
		/// <param name="ReducaoInicial">STRING com o Nmero da reducao inicial com at 4 dgitos.</param>
		/// <param name="ReducaoFinal">STRING com o Nmero da reducao final com at 4 dgitos.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_LeituraMemoriaFiscalSerialReducao(string ReducaoInicial, string ReducaoFinal);

		#endregion
			
		#region Funes das Operaes No Fiscais
		/// <summary>
		/// Imprime o comprovante no fiscal no vinculado.
		/// </summary>
		/// <param name="IndiceTotalizador">STRING com o Indice do totalizador para recebimento parcial com at 2 dgitos.</param>
		/// <param name="Valor">STRING com o Valor do recebimento com at 14 dgitos (duas casas decimais).</param>
		/// <param name="FormaPagamento">STRING com a Forma de pagamento com at 16 caracteres.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_RecebimentoNaoFiscal(string IndiceTotalizador, string Valor, string FormaPagamento);
		/// <summary>
		/// Abre o comprovante no fiscal vinculado.
		/// </summary>
		/// <param name="FormaPagamento">Forma de pagamento com at 16 caracteres.</param>
		/// <param name="Valor">Valor pago na forma de pagamento com at 14 dgitos (2 casas decimais).</param>
		/// <param name="NumeroCupom">Nmero do cupom a que se refere o comprovante com at 6 dgitos.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AbreComprovanteNaoFiscalVinculado(string FormaPagamento, string Valor, string NumeroCupom);
		/// <summary>
		/// Imprime o comprovante no fiscal vinculado.
		/// </summary>
		/// <param name="Texto">STRING com o Texto a ser impresso no comprovante no fiscal vinculado com at 618 caracteres.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_UsaComprovanteNaoFiscalVinculado(string Texto);
		/// <summary>
		/// Encerrar o comprovante no fiscal vinculado.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_FechaComprovanteNaoFiscalVinculado();
		/// <summary>
		/// Faz uma sangria na impressora (retirada de dinheiro).
		/// </summary>
		/// <param name="Valor">STRING com o Valor da sangria com at 14 dgitos (2 casas decimais).</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_Sangria(string Valor);
		/// <summary>
		/// Faz um suprimento na impressora (entrada de dinheiro).
		/// </summary>
		/// <param name="Valor">STRING com o Valor do suprimento com at 14 dgitos (2 casas decimais).</param>
		/// <param name="FormaPagamento">STRING com a Forma de pagamento com at 16 caracteres. Se no for informada, o suprimento ser feito em Dinheiro.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_Suprimento(string Valor, string FormaPagamento);
		#endregion
				
		#region Funes de Informaes da Impressora
		/// <summary>
		/// Retorna a valor acumulado dos acrscimos efetuados nos cupons. 
		/// </summary>
		/// <param name="ValorAcrescimos">Varivel string com 14 posies para receber o valor dos acrscimos.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_Acrescimos([MarshalAs(UnmanagedType.VBByRefStr)] ref string ValorAcrescimos);
		/// <summary>
		/// Retorna o valor acumulado dos itens e dos cupons cancelados.
		/// </summary>
		/// <param name="ValorCancelamentos">Varivel string com 14 posies para receber o valor dos cancelamentos com 2 casas decimais.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_Cancelamentos([MarshalAs(UnmanagedType.VBByRefStr)] ref string ValorCancelamentos);
		/// <summary>
		/// Retorna o CGC e a Inscrio Estadual do cliente/proprietrio cadastrado na impressora.
		/// </summary>
		/// <param name="CGC">Varivel string com 18 posies para receber o CGC.</param>
		/// <param name="IE">Varivel string com 15 posies para receber a Inscrio Estadual.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CGC_IE([MarshalAs(UnmanagedType.VBByRefStr)] ref string CGC,[MarshalAs(UnmanagedType.VBByRefStr)] ref string IE);
		/// <summary>
		/// Retorna o clich do proprietrio cadastrado na impressora.
		/// </summary>
		/// <param name="Cliche">Varivel string com 186 posies para receber clich cadastrado.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ClicheProprietario([MarshalAs(UnmanagedType.VBByRefStr)] ref string Cliche);
		/// <summary>
		/// Retorna o nmero de bilhetes de passagem emitidos.
		/// </summary>
		/// <param name="ContadorPassagem">Varivel string com 6 posies para receber o nmero de passagens emitidas.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ContadorBilhetePassagem(string ContadorPassagem);
		/// <summary>
		/// Retorna o nmero de vezes em que os totalizadores no sujeitos ao ICMS foram usados.
		/// </summary>
		/// <param name="Contadores">Varivel string com 44 posies para receber os contadores dos totalizadores.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ContadoresTotalizadoresNaoFiscais([MarshalAs(UnmanagedType.VBByRefStr)] ref string Contadores);
		/// <summary>
		/// Retorna os dados da impressora no momento da ltima Reduo Z.
		/// </summary>
		/// <param name="DadosReducao">Retorna os dados da impressora no momento da ltima Reduo Z.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_DadosUltimaReducao([MarshalAs(UnmanagedType.VBByRefStr)] ref string DadosReducao);
		/// <summary>
		/// Retorna a data e a hora atual da impressora.
		/// </summary>
		/// <param name="Data">Varivel string com 6 posies para receber a data atual da impressora no formato ddmmaa.</param>
		/// <param name="Hora">Varivel string com 6 posies para receber a hora atual da impressora no formato hhmmss.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_DataHoraImpressora([MarshalAs(UnmanagedType.VBByRefStr)] ref string Data, [MarshalAs(UnmanagedType.VBByRefStr)] ref string Hora);
		/// <summary>
		/// Retorna a data da ltima Reduo Z.
		/// </summary>
		/// <param name="Data">Varivel string com 6 posies para receber a data da ltima reduo no formato ddmmaa.</param>
		/// <param name="Hora">Varivel string com 6 posies parar eceber a hora da ltima reduo no formato hhmmss.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_DataHoraReducao([MarshalAs(UnmanagedType.VBByRefStr)] ref string Data, [MarshalAs(UnmanagedType.VBByRefStr)] ref string Hora);
		/// <summary>
		/// Retorna a data do ltimo movimento.
		/// </summary>
		/// <param name="Data">Varivel string com 6 posies para receber a data do movimento no formato ddmmaa.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_DataMovimento([MarshalAs(UnmanagedType.VBByRefStr)] ref string Data);
		/// <summary>
		/// Retorna a valor acumulado dos descontos.
		/// </summary>
		/// <param name="ValorDescontos">Varivel string com 14 posies para receber o valor dos descontos com 2 casas decimais.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_Descontos([MarshalAs(UnmanagedType.VBByRefStr)] ref string ValorDescontos);
		/// <summary>
		/// Retorna um nmero referente ao flag fiscal da impressora. Veja discriminao abaixo.
		/// </summary>
		/// <param name="Flag">Varivel inteira para receber um nmero representando o flag fiscal da impressora. Veja discriminao abaixo.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_FlagsFiscais(ref int Flag);
		/// <summary>
		/// Retorna o valor do Grande Total da impressora.
		/// </summary>
		/// <param name="GrandeTotal">Varivel string com 18 posies para receber o valor do grande total com 2 casas decimais.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_GrandeTotal([MarshalAs(UnmanagedType.VBByRefStr)] ref string GrandeTotal);
		/// <summary>
		/// Retorna o tempo em minutos que a impressora est ligada.
		/// </summary>
		/// <param name="Minutos">Varivel string com 4 posies para receber os minutos em que a impressora est ligada.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_MinutosLigada([MarshalAs(UnmanagedType.VBByRefStr)] ref string Minutos);
		/// <summary>
		/// Retorna o tempo em minutos que a impressora est ou esteve imprimindo.
		/// </summary>
		/// <param name="Minutos">Varivel string com 4 posies para receber os minutos em impresso.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_MinutosImprimindo([MarshalAs(UnmanagedType.VBByRefStr)] ref string Minutos);
		/// <summary>
		/// Retorna o nmero de linhas impressas aps o status de Pouco Papel.
		/// </summary>
		/// <param name="Linhas">Varivel inteira para receber a quantidade de linhas impressas.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_MonitoramentoPapel(ref int Linhas);
		/// <summary>
		/// Retorna o nmero do caixa cadastrado na impressora.
		/// </summary>
		/// <param name="NumeroCaixa">Varivel string com 4 posies para receber o nmero do caixa cadastrado na impressora.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NumeroCaixa([MarshalAs(UnmanagedType.VBByRefStr)] ref string NumeroCaixa);
		/// <summary>
		/// Retorna o nmero do cupom.
		/// </summary>
		/// <param name="NumeroCupom">Varivel string com 6 posies para receber o nmero do ltimo cupom.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NumeroCupom([MarshalAs(UnmanagedType.VBByRefStr)] ref string NumeroCupom);
		/// <summary>
		/// Retorna o nmero de cupons cancelados.
		/// </summary>
		/// <param name="NumeroCancelamentos">Varivel STRING com o tamanho de 4 bytes para receber o nmero de cupons cancelados.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NumeroCuponsCancelados([MarshalAs(UnmanagedType.VBByRefStr)] ref string NumeroCancelamentos);
		/// <summary>
		/// Retorna o nmero de intervenes tcnicas realizadas na impressora.
		/// </summary>
		/// <param name="NumeroIntervencoes">Varivel string com 4 posies para receber o nmero de intervenes.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NumeroIntervencoes([MarshalAs(UnmanagedType.VBByRefStr)] ref string NumeroIntervencoes);
		/// <summary>
		/// Retorna o nmero da loja cadastrado na impressora.
		/// </summary>
		/// <param name="NumeroLoja">Varivel string com 4 posies para receber o nmero da loja cadastrado na impressora.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NumeroLoja([MarshalAs(UnmanagedType.VBByRefStr)] ref string NumeroLoja);
		/// <summary>
		/// Retorna o nmero de operaes no fiscais executadas na impressora.
		/// </summary>
		/// <param name="NumeroOperacoes">Varivel string com 6 posies para receber o nmero de operaes.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NumeroOperacoesNaoFiscais([MarshalAs(UnmanagedType.VBByRefStr)] ref string NumeroOperacoes);
		/// <summary>
		/// Retorna o nmero de redues Z realizadas na impressora.
		/// </summary>
		/// <param name="NumeroReducoes">Varivel string com 4 posies para receber o nmero de Redues Z.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NumeroReducoes([MarshalAs(UnmanagedType.VBByRefStr)] ref string NumeroReducoes);
		/// <summary>
		/// Retorna o nmero de srie da impressora.
		/// </summary>
		/// <param name="NumeroSerie">Varivel string com o tamanho de 15 posies para receber o nmero de srie.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NumeroSerie([MarshalAs(UnmanagedType.VBByRefStr)] ref string NumeroSerie);
		/// <summary>
		/// Retorna o nmero de substituies de proprietrio.
		/// </summary>
		/// <param name="NumeroSubstituicoes">Varivel string com 4 posies para receber o nmero de substituies.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NumeroSubstituicoesProprietario([MarshalAs(UnmanagedType.VBByRefStr)] ref string NumeroSubstituicoes);
		/// <summary>
		/// Retorna as alquotas cadastradas na impressora.
		/// </summary>
		/// <param name="Aliquotas">Varivel string com o tamanho de 79 posies para receber as alquotas.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_RetornoAliquotas([MarshalAs(UnmanagedType.VBByRefStr)] ref string Aliquotas);
		/// <summary>
		/// Retorna o smbolo da moeda cadastrado na impressora.
		/// </summary>
		/// <param name="SimboloMoeda">Varivel string com 2 posies para receber o smbolo da moeda.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_SimboloMoeda([MarshalAs(UnmanagedType.VBByRefStr)] ref string SimboloMoeda);
		/// <summary>
		/// Retorna o valor do subtotal do cupom.
		/// </summary>
		/// <param name="SubTotal">Varivel string com o tamanho de 14 posies para receber o subtotal do cupom.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_SubTotal([MarshalAs(UnmanagedType.VBByRefStr)] ref string SubTotal);
		/// <summary>
		/// Retorna o nmero do ltimo item vendido.
		/// </summary>
		/// <param name="NumeroItem">Varivel string com 4 posies para receber o nmero do ltimo item vendido.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_UltimoItemVendido([MarshalAs(UnmanagedType.VBByRefStr)] ref string NumeroItem);
		/// <summary>
		/// Retorna o valor acumulado em uma determinada forma de pagamento.
		/// </summary>
		/// <param name="Forma">Varivel STRING com at 16 posies com a descrio da Forma de Pagamento que deseja retornar o seu valor.</param>
		/// <param name="ValorForma">Varivel STRING com 14 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ValorFormaPagamento(string Forma, [MarshalAs(UnmanagedType.VBByRefStr)] ref string ValorForma);
		/// <summary>
		/// Retorna o valor pago no ltimo cupom.
		/// </summary>
		/// <param name="ValorCupom">Varivel string com 14 posies para receber o valor pago no ltimo cupom.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ValorPagoUltimoCupom([MarshalAs(UnmanagedType.VBByRefStr)] ref string ValorCupom);
		/// <summary>
		/// Retorna o valor acumulado em um determinado totalizador no fiscal.
		/// </summary>
		/// <param name="Totalizador">Varivel STRING com at 19 posies com a descrio do Totalizador.</param>
		/// <param name="ValorTotalizador">Varivel STRING com 14 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ValorTotalizadorNaoFiscal(string Totalizador, [MarshalAs(UnmanagedType.VBByRefStr)] ref string ValorTotalizador);
		/// <summary>
		/// Retorna as alquotas de vinculao ao ISS.
		/// </summary>
		/// <param name="Flag">Varivel string com 79 posies para receber as alquotas vinculadas ao Iss.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaAliquotasIss([MarshalAs(UnmanagedType.VBByRefStr)] ref string Flag);
		/// <summary>
		/// Verifica se a Eprom est conectada.
		/// </summary>
		/// <param name="Flag">Varivel string com 2 posio para receber o flag de Eprom conectada. Onde: 
		/// <br></br>1 - Eprom conectada 
		///	<br></br>0 - Eprom desconectada. 
		///	</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaEpromConectada([MarshalAs(UnmanagedType.VBByRefStr)] ref string Flag);
		/// <summary>
		/// Retorna os departamentos e seus valores acumulados.
		/// </summary>
		/// <param name="Departamentos">Varivel string com 1019 posies para receber as informaes dos departamentos.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaDepartamentos([MarshalAs(UnmanagedType.VBByRefStr)] ref string Departamentos);
		/// <summary>
		/// Retorna o estado da impressora.
		/// </summary>
		/// <param name="ACK">Varivel inteira para receber o primeiro byte.</param>
		/// <param name="ST1">Varivel inteira para receber o segundo byte</param>
		/// <param name="ST2">Varivel inteira para receber o terceiro byte</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaEstadoImpressora(ref int ACK, ref int ST1, ref int ST2);
		/// <summary>
		/// Retorna as formas de pagamento e seus valores acumulados.
		/// </summary>
		/// <param name="Formas">Varivel string com 3016 posies para receber as formas programadas.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaFormasPagamento([MarshalAs(UnmanagedType.VBByRefStr)] ref string Formas);
		/// <summary>
		/// Retorna os ndices das alquotas de ISS. 
		/// </summary>
		/// <param name="Modo">Varivel string com o tamanho de 48 posies para receber os ndices das alquotas de ISS.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaIndiceAliquotasIss([MarshalAs(UnmanagedType.VBByRefStr)] ref string Flag);
		/// <summary>
		/// Verifica se a impressora est em modo normal ou em interveno tcnica
		/// </summary>
		/// <param name="Modo">Varivel string com 1 posio para receber o modo de operao da impressora. Onde: 
		///		<br></br>1 - Modo normal 
		///		<br></br>0 - Interveno tcnica.
		///	</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaModoOperacao([MarshalAs(UnmanagedType.VBByRefStr)] ref string Modo);
		/// <summary>
		/// Retorna os recebimentos no fiscais no vinculados programados na impressora.
		/// </summary>
		/// <param name="Recebimentos">Varivel string com 2200 posies para receber as informaes.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaRecebimentoNaoFiscal([MarshalAs(UnmanagedType.VBByRefStr)] ref string Recebimentos);
		/// <summary>
		/// Retorna o tipo de impressora.
		/// </summary>
		/// <param name="TipoImpressora">Varivel inteira para receber o tipo da impressora (veja abaixo no help os valores retornados).</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaTipoImpressora(ref int TipoImpressora);
		/// <summary>
		/// Retorna a descrio dos totalizadores no fiscais programados na impressora.
		/// </summary>
		/// <param name="Totalizadores">Varivel string com 179 posies para receber a descrio dos totalizadores no fiscais programados</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaTotalizadoresNaoFiscais([MarshalAs(UnmanagedType.VBByRefStr)] ref string Totalizadores);
		/// <summary>
		/// Retorna os totalizadores parciais cadastrados na impressora.
		/// </summary>
		/// <param name="Totalizadores">Varivel string com o tamanho de 445 posies para receber os totalizadores parciais cadastrados.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaTotalizadoresParciais([MarshalAs(UnmanagedType.VBByRefStr)] ref string Totalizadores);
		/// <summary>
		/// Retorna 1 se a impressora estiver no modo truncamento e 0 se estiver no modo arredondamento.
		/// </summary>
		/// <param name="Flag">Varivel string com 1 posio para receber o flag de truncamento</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaTruncamento([MarshalAs(UnmanagedType.VBByRefStr)] ref string Flag);
		/// <summary>
		/// Retorna a verso do firmware da impressora.
		/// </summary>
		/// <param name="VersaoFirmware">Varivel string com o tamanho de 4 posies para receber a verso do firmware.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VersaoFirmware([MarshalAs(UnmanagedType.VBByRefStr)] ref string VersaoFirmware);
		/// <summary>
		/// Imprime configuraes da impressora fiscal em um relatrio gerencial. Ser emitida uma leitura X antes. Veja abaixo em "Observaes" as informaes que sero impressas. 
		/// </summary>
		/// <returns></returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ImprimeConfiguracoes();

		#endregion
		
		#region Funes de Autenticao e Gaveta de Dinheiro
		/// <summary>
		/// Permite a autenticao de documentos.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_Autenticacao();
		/// <summary>
		/// Programa um caracter grfico para autenticao.
		/// </summary>
		/// <param name="Parametros">STRING com os 18 valores para programao do caracter grfico, separados por vrgula. </param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ProgramaCaracterAutenticacao(string Parametros);
		/// <summary>
		/// Abre a gaveta de dinheiro.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AcionaGaveta();
		/// <summary>
		/// Retorna se a gaveta est fechada ou aberta.
		/// </summary>
		/// <param name="EstadoGaveta">INTEIRO com a Varivel para receber o estado da gaveta, onde: 
		///		<br></br>Estado = 1 sensor em nvel 1 (fechada) 
		///		<br></br>Estado = 0 sensor em nvel 0 (aberta) 
		///	</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaEstadoGaveta(out int EstadoGaveta);
		#endregion
		
		#region Funes de Impresso de Cheques
		/// <summary>
		/// Cancela a impresso do cheque que est sendo aguardado pela impressora. O cheque que est em impresso no pode ser cancelado.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CancelaImpressaoCheque();
		/// <summary>
		/// Imprime cheque na impressora MP-40 FI II Bematech e na impressora YANCO 8500.
		/// </summary>
		/// <param name="Banco">STRING com o Nmero do banco com 3 dgitos.</param>
		/// <param name="Valor">STRING com o Valor do cheque com at 14 dgitos.</param>
		/// <param name="Favorecido">STRING com o Favorecido com at 45 caracteres.</param>
		/// <param name="Cidade">STRING com a Cidade com at 27 caracteres.</param>
		/// <param name="Data">STRING com a Data no formato ddmmaa, dd/mm/aa, ddmmaaaa ou dd/mm/aaaa.</param>
		/// <param name="Mensagem">STRING com o Comentrios at 120 caracteres. A mensagem ser impressa 1 (uma) linha aps a cidade.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ImprimeCheque(string Banco, string Valor, string Favorecido, string Cidade, string Data, string Mensagem);
		/// <summary>
		/// Imprime cpia do ltimo cheque impresso.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ImprimeCopiaCheque();
		/// <summary>
		/// Inclui o nome da cidade e do favorecido no arquivo de configurao BEMAFI32.INI.
		/// </summary>
		/// <param name="Cidade">STRING com o Nome da cidade com at 27 caracteres.</param>
		/// <param name="Favorecido">STRING com o Nome do favorecido com at 45 caracteres.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_IncluiCidadeFavorecido(string Cidade, string Favorecido);
		/// <summary>
		/// Programa o nome da moeda no plural para a impresso de cheques. Ex. (Reais)
		/// </summary>
		/// <param name="MoedaPlural">STRING com o Nome da moeda no plural com at 22 caracteres.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ProgramaMoedaPlural(string MoedaPlural);
		/// <summary>
		/// Programa o nome da moeda no singular para a impresso de cheques. Ex. (Real)
		/// </summary>
		/// <param name="MoedaSingular">STRING com o Nome da Moeda no singular com at 19 caracteres.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ProgramaMoedaSingular(string MoedaSingular);
		/// <summary>
		/// Verifica o status do cheque.
		/// </summary>
		/// <param name="StatusCheque">Varivel inteira para receber o status do cheque.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaStatusCheque(ref int StatusCheque);
		#endregion
		
		#region Outras Funes
		/// <summary>
		/// Faz a abertura do caixa emitindo um suprimento e uma leitura X. Essa funo grava o COO inicial e o Grande Total inicial que sero usados na funo ECF_RelatorioTipo60Mestre. Portanto, se voc for emitir o relatrio "tipo 60 mestre"  obrigatrio o uso dessa funo.
		/// </summary>
		/// <param name="Valor">STRING com o Valor do suprimento com at 14 dgitos (2 casas decimais). Informe o valor "0" para no fazer suprimento.</param>
		/// <param name="FormaPagto">STRING com a Forma de pagamento com at 16 caracteres. Se no for informado, o suprimento ser feito em Dinheiro.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AberturaDoDia(string Valor, string FormaPagto);
		/// <summary>
		/// Abre a porta serial para comunicao entre a impressora e o micro. 
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AbrePortaSerial();
		/// <summary>
		/// Faz o fechamento do dia emitindo uma Reduo Z. Essa funo grava o COO final e o Grande Total final que sero usados na funo ECF_RelatorioTipo60Mestre.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_FechamentoDoDia();
		/// <summary>
		/// Fecha a porta serial.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_FechaPortaSerial();
		/// <summary>
		/// Imprime os departamentos e seus valores acumulados em um relatrio gerencial. Ser emitida uma leitura X antes. Essas informaes eram impressas na leitura X at a verso 3.0 e foram retiradas por solicitao do fisco. 
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ImprimeDepartamentos();
		/// <summary>
		/// Gera o relatrio "Mapa Resumo" referente ao movimento do dia. As informaes sero geradas no arquivo RETORNO.TXT no diretrio configurado no parmetro "path" do arquivo ini. O diretrio default configurado  o diretrio raiz (C:\).
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_MapaResumo();
		/// <summary>
		/// Gera o relatrio "Tipo 60 analtico" exigido pelo convnio de ICMS 85/2001. As informaes sero geradas no arquivo RETORNO.TXT no diretrio configurado no parmetro "path" do arquivo ini. O diretrio default  o diretrio raiz (C:\).
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_RelatorioTipo60Analitico();
		/// <summary>
		/// Gera o relatrio "Tipo 60 Mestre" exigido pelo convnio de ICMS 85/2001. As informaes sero geradas no arquivo RETORNO.TXT no diretrio configurado no parmetro "path" do arquivo ini. O diretrio default  o diretrio raiz (C:\).
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_RelatorioTipo60Mestre();
		/// <summary>
		/// L o retorno da impressora referente ao ltimo comando enviado. 
		/// </summary>
		/// <param name="ACK">Varivel INTEIRA para receber o primeiro byte.</param>
		/// <param name="ST1">Varivel INTEIRA para receber o segundo byte.</param>
		/// <param name="ST2">Varivel INTEIRA para receber o terceiro byte.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_RetornoImpressora(ref int ACK, ref int ST1, ref int ST2);
		/// <summary>
		/// Verifica se a impressora est ligada ou conectada no computador.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaImpressoraLigada();
		/// <summary>
		/// Reseta a impressora em caso de erro.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ResetaImpressora();
		/// <summary>
		/// Abre o cupom na impressora bilhete de passagem.
		/// </summary>
		/// <param name="ImprimeValorFinal">"1" - Imprime o valor pago no final do cupom. "0" - No Imprime o valor pago no final do cupom.</param>
		/// <param name="ImprimeEnfatizado">"1" - Imprime as informaes "EMBARQUE, POLTRONA e PLATAFORMA" enfatizadas. "0" - No Imprime as informaes enfatizadas (negrito).</param>
		/// <param name="Embarque">STRING com at 40 caracteres com o local de embarque.</param>
		/// <param name="Destino">STRING com at 40 caracteres com o local de destino.</param>
		/// <param name="Linha">STRING com at 40 caracteres com o nome da linha (Ex. Curitiba x So Paulo - Executivo).</param>
		/// <param name="Prefixo">STRING com at 40 caracteres.</param>
		/// <param name="Agente">STRING com at 40 caracteres com o nome do agente.</param>
		/// <param name="Agencia">STRING com at 40 caracteres com o nome da agncia.</param>
		/// <param name="Data">STRING com a data de embarque no formato ddmmaa, dd/mm/aa, ddmmaaaa ou dd/mm/aaaa.</param>
		/// <param name="Hora">STIRNG com a hora do embarque no formato hhmmss ou hh:mm:ss.</param>
		/// <param name="Poltrona">STRING com at 2 caracteres com o nmero da poltrona.</param>
		/// <param name="Plataforma">STRING com at 3 caracteres com o nmero da poltrona.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AbreBilhetePassagem(string ImprimeValorFinal, string ImprimeEnfatizado, string	Embarque, string Destino, string Linha, string Prefixo, string Agente, string	Agencia, string	Data, string Hora, string Poltrona, string Plataforma);
		/// <summary>
		/// Imprime um carn de pagamento.
		/// </summary>
		/// <param name="Titulo">STRING com o titulo para o carn, impresso centralizado e expandido em cada parcela. Limitado em 20 caracteres.</param>
		/// <param name="Parcelas">STRING com o(s) valor(es) de cada parcela, separadas por ';' (ponto virgula), com duas casas decimais obrigatriamente. Formatos vlidos: "23,23;1.200,00" ou "2323;120000". Ver observaes abaixo</param>
		/// <param name="Datas">STRING com a(s) data(s) de vencimento das parcelas separadas por ';'. Formato vlidos: "10/10/2003;10112003; ".</param>
		/// <param name="Quantidade">INTEGER com a quantidade de Parcelas. Deve ser diferente de zero.</param>
		/// <param name="Texto">STRING com o texto livre com at 200 caracteres.</param>
		/// <param name="Cliente">STRING com o nome do cliente com at 30 caracteres</param>
		/// <param name="RG_CPF">STRING com o nmero do RG/CPF do cliente. Pode ser nulo ou vazio.</param>
		/// <param name="Cupom">STRING com o COO do Cupom Fiscal com 6 caracteres.</param>
		/// <param name="Vias">INTEGER com a quantidade de Vias. (1 ou 2 apenas).</param>
		/// <param name="Assina">INTEGER para habilitar ou no a assinatura do cliente, onde: 
		///		<br></br>1: Habilita a impresso de uma linha tracejada para a assinatura do cliente. 
		///		<br></br>0: No habilita a impresso da linha tracejada para a assinatura do cliente. 
		///	</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ImpressaoCarne(string Titulo, string Parcelas, string Datas,	int	Quantidade, string Texto, string Cliente, string RG_CPF, string Cupom, int Vias, int Assina);
		#endregion	
		
		#region Funes para a Impressora Restaurante
		/// <summary>
		/// Abre o cupom de conferncia de mesa e imprime os itens registrados nessa mesa. Essa funo mantm o cupom de conferncia aberto permitindo registrar outros itens na mesa. S so permitidos registros com o mesmo nmero da mesa a qual foi aberta o cupom de conferncia.
		/// </summary>
		/// <param name="Mesa">STRING com o nmero da Mesa com at 4 dgitos.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AbreConferenciaMesa(string Mesa);
		/// <summary>
		/// Abre o cupom fiscal na impressora restaurante e imprime os itens registrados na mesa. Se a mesa for "0000", abre o cupom e aguarda a venda dos itens.
		/// </summary>
		/// <param name="Mesa">STRING com o nmero da Mesa com at 4 dgitos.</param>
		/// <param name="CGC_CPF">STRING com at 29 caracteres.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AbreCupomRestaurante(string Mesa, string CGC_CPF);
		/// <summary>
		/// Essa funo cancela um registro de venda da mesa informada.
		/// </summary>
		/// <param name="Mesa">STRING com o nmero da Mesa at 4 dgitos.</param>
		/// <param name="Codigo">STRING com o cdigo do item at 14 dgitos.</param>
		/// <param name="Descricao">STRING com a descrio do item at 17 caracteres.</param>
		/// <param name="Aliquota">STRING com o valor ou o ndice da alquota tributria. Se for o valor deve ser informado com o tamanho de 4 caracteres ou 5 com a vrgula. Se for o ndice da alquota deve ser 2 caracteres. Ex. (18,00 para o valor ou 05 para o ndice).</param>
		/// <param name="Quantidade">STRING com at 6 dgitos (so trs casas decimais).</param>
		/// <param name="ValorUnitario">STRING com at 8 dgitos (so duas casas decimais).</param>
		/// <param name="FlagAcrescimoDesconto"> "A" para acrscimo ou "D" para desconto.</param>
		/// <param name="ValorAcrescimoDesconto"> STRING com at 8 dgitos (so duas casas decimais). Se no tiver acrscimo nem desconto use "0" no valor.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CancelaVenda(string Mesa, string Codigo, string Descricao, string Aliquota, string Quantidade, string ValorUnitario, string FlagAcrescimoDesconto, string ValorAcrescimoDesconto);
		/// <summary>
		/// Emite um cupom de conferncia de mesa. Essa funo rene as funes ECF_AbreConferenciaMesa e ECF_FechaConferenciaMesa. Ela abre e fecha o cupom de conferncia no permitindo registrar produtos nesse cupom de conferncia.
		/// </summary>
		/// <param name="Mesa">STRING com o nmero da Mesa com at 4 dgitos.</param>
		/// <param name="FlagAcrescimoDesconto">"A" para acrscimo e "D" para desconto.</param>
		/// <param name="TipoAcrescimoDesconto">"$" para acrscimo ou desconto por valor e "%" para percentual.</param>
		/// <param name="ValorAcrescimoDesconto">STRING com no mximo 14 dgitos para acrscimo ou desconto por valor e 4 dgitos para acrscimo ou desconto por percentual (so duas casas decimais).</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ConferenciaMesa(string Mesa, string FlagAcrescimoDesconto, string TipoAcrescimoDesconto, string ValorAcrescimoDesconto);
		/// <summary>
		/// Permite que a conta seja dividida por todos os clientes. Essa funo termina o fechamento do cupom fiscal e imprime um cupom para cada cliente.
		/// </summary>
		/// <param name="NumeroCupons">STRING com at 2 dgitos com o nmero de cupons em que a conta ser divida. O nmero mnimo de cupons  2 e o mximo  20.</param>
		/// <param name="ValorPago">STRING com os valores pagos por cada cliente. Os valores devem ter no mximo 14 dgitos e serem separados por ponto e vrgula ";". Ex.: 10,00; 5,00</param>
		/// <param name="CGC_CPF">STRING com o CPF dos clientes. Os CPF's devem ter no mximo 29 caracteres e serem separados por ponto e vrgula ";"</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ContaDividida(string NumeroCupons, string ValorPago, string CGC_CPF);
		/// <summary>
		/// Retorna os itens do cardpio pela serial com as seguintes informaes: Cdigo, Descrio, Alquota e Quantidade.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CardapioPelaSerial();
		/// <summary>
		/// Fecha o cupom de conferncia de mesa. Essa funo permite incluir um acrscimo ou desconto sobre o valor total vendido na mesa. 
		/// </summary>
		/// <param name="FlagAcrescimoDesconto">"A" para acrscimo ou "D" para desconto.</param>
		/// <param name="TipoAcrescimoDesconto">"$" para acrscimo ou desconto por valor e "%" para percentual.</param>
		/// <param name="ValorAcrescimoDesconto">STRING com no mximo 14 dgitos para acrscimo ou desconto por valor e 4 dgitos para acrscimo ou desconto por percentual (so duas casas decimais).</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_FechaConferenciaMesa(string FlagAcrescimoDesconto, string TipoAcrescimoDesconto, string ValorAcrescimoDesconto);
		/// <summary>
		/// Essa funo permite fechar o cupom fiscal com formas de pagamento e permite dividir a conta por todos os clientes.
		/// </summary>
		/// <param name="NumeroCupons">STRING com at 2 dgitos com o nmero de cupons em que a conta ser divida. O nmero mnimo de cupons  2 e o mximo  20.</param>
		/// <param name="FlagAcrescimoDesconto">Indica se haver acrscimo ou desconto no cupom. "A" para acrscimo ou "D" para desconto.</param>
		/// <param name="TipoAcrescimoDesconto">Indica se o acrscimo ou desconto  por valor ou por percentual. "$" para desconto por valor ou "%" para percentual.</param>
		/// <param name="ValorAcrescimoDesconto">STRING com no mximo 14 dgitos para acrscimo ou desconto por valor e 4 dgitos para acrscimo ou desconto percentual.</param>
		/// <param name="FormasPagamento">STRING com as formas de pagamento. As formas devem ser separadas por ponto e vrgula (";") se for utilizada mais de uma, e deve ter no mximo 16 caracteres cada. Ex: Dinheiro;Carto.  permitido a utilizao de at 20 formas.</param>
		/// <param name="ValorFormasPagamento">STRING com os valores das formas de pagamento. Os valores devem ter no mximo 14 dgitos e serem separados por ponto e vrgula ";".</param>
		/// <param name="ValorPagoCliente">STRING com os valores pagos por cada cliente. Obedecem  mesma situao acima.</param>
		/// <param name="CGC_CPF">STRING com o CPF dos clientes. Os CPF's devem ter no mximo 29 caracteres e serem separados por ponto e vrgula ";".</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_FechaCupomContaDividida(string NumeroCupons, string FlagAcrescimoDesconto, string TipoAcrescimoDesconto, string ValorAcrescimoDesconto, string FormasPagamento, string ValorFormasPagamento, string ValorPagoCliente, string CGC_CPF);
		/// <summary>
		/// Fecha o cupom fiscal na impressora restaurante com acrscimo ou desconto, usando apenas uma forma de pagamento.
		/// </summary>
		/// <param name="FormaPagamento">STRING com o nome da forma de pagamento com no mximo 16 caracteres.</param>
		/// <param name="FlagAcrescimoDesconto">Indica se haver acrscimo ou desconto no cupom. "A" para acrscimo ou "D" para desconto.</param>
		/// <param name="TipoAcrescimoDesconto">Indica se o acrscimo ou desconto  por valor ou por percentual. "$" para desconto por valor ou "%" para percentual.</param>
		/// <param name="ValorAcrescimoDesconto">STRING com no mximo 14 dgitos para acrscimo ou desconto por valor e 4 dgitos para acrscimo ou desconto por percentual.</param>
		/// <param name="ValorFormaPagto">STRING com o Valor pago com no mximo 14 dgitos.</param>
		/// <param name="Mensagem">STRING com a Mensagem promocional com at 490 caracteres.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_FechaCupomRestaurante(string FormaPagamento, string FlagAcrescimoDesconto, string TipoAcrescimoDesconto, string ValorAcrescimoDesconto, string ValorFormaPagto, string Mensagem);
		/// <summary>
		///Imprime os itens do cardpio com as seguintes informaes: Cdigo, Descrio, Alquota e Quantidade. 
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ImprimeCardapio();
		/// <summary>
		/// Faz um registro de venda na mesa informada e cadastra o item no cardpio com o cdigo informado se ele ainda no existir.
		/// </summary>
		/// <param name="Mesa">STRING com o nmero da Mesa at 4 dgitos.</param>
		/// <param name="Codigo">STRING com o cdigo do item at 14 dgitos.</param>
		/// <param name="Descricao">STRING com a descrio do item at 17 caracteres.</param>
		/// <param name="Aliquota">STRING com o valor ou o ndice da alquota tributria. Se for o valor deve ser informado com o tamanho de 4 caracteres ou 5 com a vrgula. Se for o ndice da alquota deve ser 2 caracteres. Ex. (18,00 para o valor ou 05 para o ndice).</param>
		/// <param name="Quantidade">STRING com at 6 dgitos (so trs casas decimais).</param>
		/// <param name="ValorUnitario">STRING com at 8 dgitos (so duas casas decimais).</param>
		/// <param name="FlagAcrescimoDesconto">"A" para acrscimo ou "D" para desconto.</param>
		/// <param name="ValorAcrescimoDesconto">STRING com at 8 dgitos (so duas casas decimais). Se no tiver acrscimo nem desconto use "0" no valor.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_RegistraVenda(string Mesa, string Codigo, string Descricao, string Aliquota, string Quantidade, string ValorUnitario, string FlagAcrescimoDesconto, string ValorAcrescimoDesconto);
		/// <summary>
		/// Retorna os registros de venda da mesa pela porta serial.
		/// </summary>
		/// <param name="Mesa">STRING com o nmero da Mesa com at 4 dgitos.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_RegistroVendaSerial(string Mesa);
		/// <summary>
		/// Imprime um relatrio das mesas que esto abertas.
		/// </summary>
		/// <param name="TipoRelatorio">INTEIRO, onde: 0 para relatorio parcial ou 1 para relatrio completo.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_RelatorioMesasAbertas(int TipoRelatorio);
		/// <summary>
		/// Retorna, pela porta serial da impressora, o relatrio das mesas que esto abertas.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_RelatorioMesasAbertasSerial();
		/// <summary>
		/// Permite a transferncia parcial ou total dos itens registrados em uma mesa para outra.
		/// </summary>
		/// <param name="MesaOrigem">STRING com o nmero da Mesa de origem com at 4 dgitos.</param>
		/// <param name="Codigo">STRING com o cdigo do item com at 14 dgitos.</param>
		/// <param name="Descricao">STRING com a Descrio do item com at 17 caracteres.</param>
		/// <param name="Aliquota">STRING com o valor ou o ndice da alquota tributria. Se for o valor deve ser informado com o tamanho de 4 caracteres ou 5 com a vrgula. Se for o ndice da alquota deve ser 2 caracteres. Ex. (18,00 para o valor ou 05 para o ndice ).</param>
		/// <param name="Quantidade">STRING com at 6 dgitos (so trs casas decimais).</param>
		/// <param name="ValorUnitario">STRING com at 8 dgitos (so duas casas decimais).</param>
		/// <param name="FlagAcrescimoDesconto">"A" para acrscimo e "D" para desconto.</param>
		/// <param name="ValorAcrescimoDesconto"> STRING com at 8 dgitos (so duas casas decimais). Se no tiver acrscimo nem desconto use "0" no valor.</param>
		/// <param name="MesaDestino">STRING com o nmero da Mesa de destino com at 4 dgitos.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_TransferenciaItem(string MesaOrigem, string Codigo, string Descricao, string Aliquota, string Quantidade, string ValorUnitario, string FlagAcrescimoDesconto, string ValorAcrescimoDesconto, string MesaDestino);
		/// <summary>
		/// Faz a transferncia dos registros de venda da mesa de origem para a mesa de destino, se a mesa de destino j tiver itens registrados os registros sero acrescentados. 
		/// </summary>
		/// <param name="MesaOrigem">STRING com o cdigo da Mesa de origem com at 4 dgitos.</param>
		/// <param name="MesaDestino">STRING com o cdigo da Mesa de destino com at 4 dgitos.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_TransferenciaMesa(string MesaOrigem, string MesaDestino);
		/// <summary>
		/// Retorna a quantidade de bytes livres na memria da impressora para registros de venda ou itens de cardpio.
		/// </summary>
		/// <param name="Bytes">Varivel string com o tamanho de 6 posies para o valor correspondente ao bytes de memria livres.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaMemoriaLivre(string Bytes);
		/// <summary>
		/// Permite fechar o cupom de forma resumida, ou seja, sem acrscimo ou desconto no cupom e com apenas uma forma de pagamento. Essa funo l o subtotal do cupom para fech-lo.
		/// </summary>
		/// <param name="FormaPagamento">STRING com a Forma de pagamento com no mximo 16 caracteres.</param>
		/// <param name="Mensagem">STRING com a Mensagem promocional com at 490 caracteres.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_FechaCupomResumidoRestaurante(string FormaPagamento, string Mensagem);
		#endregion

		#region Funes da Impressora Fiscal MFD
		/// <summary>
		/// Abre o cupom na impressora bilhete de passagem MFD.
		/// </summary>
		/// <param name="Embarque">STRING com at 40 caracteres com o local de embarque.</param>
		/// <param name="Destino">STRING com at 40 caracteres com o local de destino.</param>
		/// <param name="Linha">STRING com at 40 caracteres com o nome da linha (Ex. Curitiba x So Paulo  Executivo</param>
		/// <param name="Agencia">STRING com at 40 caracteres com o nome da agncia.</param>
		/// <param name="Data">STRING com a data de embarque no formato ddmmaa, dd/mm/aa, ddmmaaaa ou dd/mm/aaaa.</param>
		/// <param name="Hora">STRING com a hora do embarque no formato hhmmss ou hh:mm:ss.</param>
		/// <param name="Poltrona">STRING com at 2 caracteres com o nmero da poltrona.</param>
		/// <param name="Plataforma">STRING com at 3 caracteres com o nmero da plataforma.</param>
		/// <param name="TipoPassagem"> STRING com: 
		///		<br></br>0 (zero) - passagem Rodovirio Intermunicipal; 
		///		<br></br>1 (um) - passagem Ferrovirio Intermunicipal; 
		///		<br></br>2 (dois) - passagem Aquavirio Intermunicipal; 
		///		<br></br>3 (trs) - passagem Rodovirio Interestadual; 
		///		<br></br>4 (quatro) - passagem Ferrovirio Interestadual; 
		///		<br></br>5 (cinco) - passagem Aquavirio Interestadual; 
		///		<br></br>6 (seis) - passagem Rodovirio Internacional; 
		///		<br></br>7 (sete) - passagem Ferrovirio Internacional ou; 
		///		<br></br>8 (oito) - passagem Aquavirio Internacional. 
		/// </param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AbreBilhetePassagemMFD(string Embarque, string Destino, string Linha, string Agencia, string Data, string Hora, string Poltrona, string Plataforma, string TipoPassagem);
		/// <summary>
		/// Abre o Comprovante No Fiscal Vinculado
		/// </summary>
		/// <param name="FormaPagamento">STRING com a Forma de Pagamento com at 16 caracteres.</param>
		/// <param name="Valor"> STRING com o Valor Pago na forma de pagamento do cupom a que se refere o comprovante, com at 14 dgitos (2 casas decimais).</param>
		/// <param name="NumeroCupom">STRING com o Nmero do cupom a que se refere o comprovante com at 6 dgitos</param>
		/// <param name="CGC">STRING com at 29 caracteres com o CGC ou CPF do cliente.</param>
		/// <param name="nome">STRING com at 30 caracteres com o nome do cliente.</param>
		/// <param name="Endereco">STRING com at 80 caracteres com o endereo do cliente. </param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AbreComprovanteNaoFiscalVinculadoMFD(string FormaPagamento, string Valor, string NumeroCupom, string CGC, string nome, string Endereco);
		/// <summary>
		/// Abre o cupom fiscal na impressora MFD. 
		/// </summary>
		/// <param name="CGC">STRING at 29 caracteres com o CGC ou CPF do cliente.</param>
		/// <param name="Nome">STRING at 30 caracteres com o nome do cliente.</param>
		/// <param name="Endereco">STRING at 80 caracteres com o endereo do cliente.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AbreCupomMFD(string CGC, string Nome, string Endereco);
		/// <summary>
		/// Abre o comprovante no fiscal no vinculado para que sejam lanados os recebimentos no fiscais.
		/// </summary>
		/// <param name="CGC">STRING at 29 caracteres com o CGC ou CPF do cliente.</param>
		/// <param name="Nome">STRING at 30 caracteres com o nome do cliente.</param>
		/// <param name="Endereco">STRING at 80 caracteres com o endereo do cliente.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AbreRecebimentoNaoFiscalMFD(string CGC, string Nome, string Endereco);
		/// <summary>
		/// Abre Relatrio Gerencial, na impressora fiscal MFD.
		/// </summary>
		/// <param name="Indice">STRING numrica com o valor entre 1 e 30, com o ndice do relatrio.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AbreRelatorioGerencialMFD(string Indice);
		/// <summary>
		/// Efetua acrscimo ou desconto em qualquer item enquanto o cupom fiscal no estiver totalizado.
		/// </summary>
		/// <param name="Item">STRING numrica at 3 dgitos com o nmero do item.</param>
		/// <param name="AcrescimoDesconto">Indica se  acrscimo ou desconto. 'A' para acrscimo ou 'D' para desconto.</param>
		/// <param name="TipoAcrescimoDesconto">Indica se o acrscimo ou desconto  por valor ou por percentual. '$' para desconto por valor e '%' para percentual.</param>
		/// <param name="ValorAcrescimoDesconto">STRING com no mximo 14 dgitos para acrscimo ou desconto por valor e 4 dgitos para acrscimo ou desconto percentual.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AcrescimoDescontoItemMFD(string Item, string AcrescimoDesconto, string TipoAcrescimoDesconto, string ValorAcrescimoDesconto);
		/// <summary>
		/// Efetua acrscimo ou desconto em subtotal do recebimento no fiscal.
		/// </summary>
		/// <param name="cFlag">STRING com "A" para Acrscimo ou "'D" para Desconto.</param>
		/// <param name="cTipo">STRING com "$" para acrscimo ou desconto por valor, ou "%" para acrscimo ou desconto por percentual.</param>
		/// <param name="cValor">STRING com no mximo 14 dgitos para o valor ou 4 dgitos para o percentual.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AcrescimoDescontoSubtotalRecebimentoMFD(string cFlag, string cTipo, string cValor);
		/// <summary>
		/// Efetua acrscimo ou desconto em subtotal do cupom. 
		/// </summary>
		/// <param name="cFlag">STRING com "A" para Acrscimo ou "D" para Desconto.</param>
		/// <param name="cTipo">STRING com "$" para Acrscimo ou Desconto por valor, ou "%" para Acrscimo ou Desconto percentual.</param>
		/// <param name="cValor">STRING com o valor no mximo de 14 dgitos para Acrscimo ou Desconto, ou valor com 4 dgitos para Acrscimo ou Desconto por percentual.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AcrescimoDescontoSubtotalMFD(string cFlag, string cTipo, string cValor);
		/// <summary>
		/// Permite a autenticao de documentos.
		/// </summary>
		/// <param name="Linhas">STRING numrica com valor entre 1 e 99 com o nmero de linhas que sero saltadas para imprimir o texto.</param>
		/// <param name="Texto">STRING com at 48 caracteres com o texto a ser impresso.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_AutenticacaoMFD(string Linhas, string Texto);
		/// <summary>
		/// Cancela a acrscimo ou a desconto dado no item.
		/// </summary>
		/// <param name="cFlag">STRING com "A" para cancelar o Acrscimo ou "D" para cancelar o Desconto.</param>
		/// <param name="cItem">STRING de at 3 dgitos com o nmero do item a ser cancelado restrito aos 300 ltimos registros efetuados.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CancelaAcrescimoDescontoItemMFD(string cFlag, string cItem);
		/// <summary>
		/// Cancela acrscimo e desconto efetuados em subtotal do cupom. 
		/// </summary>
		/// <param name="cFlag">STRING com "A" para cancelar o Acrscimo ou "D" para cancelar o Desconto, dado no subtotal.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CancelaAcrescimoDescontoSubtotalMFD(string cFlag);
		/// <summary>
		/// Cancela acrscimo e desconto efetuados em subtotal do recebimento no fiscal.
		/// </summary>
		/// <param name="cFlag">STRING com "A" para cancelar o Acrscimo ou "D" para cancelar o Desconto, dado no subtotal do recebimento.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CancelaAcrescimoDescontoSubtotalRecebimentoMFD(string cFlag);
		/// <summary>
		/// Cancela o ltimo cupom emitido.
		/// </summary>
		/// <param name="CGC">STRING at 29 caracteres com o CGC ou CPF do cliente. </param>
		/// <param name="Nome">STRING at 30 caracteres com o nome do cliente.</param>
		/// <param name="Endereco">STRING at 80 caracteres com o endereo do cliente.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CancelaCupomMFD(string CGC, string Nome, string Endereco);
		/// <summary>
		/// Cancela o recebimento no fiscal.
		/// </summary>
		/// <param name="CGC">STRING at 29 caracteres com o CGC ou CPF do cliente</param>
		/// <param name="Nome">STRING at 30 caracteres com o nome do cliente.</param>
		/// <param name="Endereco">STRING at 80 caracteres com o endereo do cliente.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CancelaRecebimentoNaoFiscalMFD(string CGC, string Nome, string Endereco);
		/// <summary>
		/// Retorna o nmero de comprovantes no fiscais no emitidos.
		/// </summary>
		/// <param name="Comprovantes">Varivel STRING com o tamanho de 4 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ComprovantesNaoFiscaisNaoEmitidosMFD(string Comprovantes);
		/// <summary>
		///  Retorna o CNPJ do cliente cadastrado na impressora. 
		/// </summary>
		/// <param name="CNPJ">Varivel STRING com o tamanho de 20 posies para receber o CNPJ.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CNPJMFD(string CNPJ);
		/// <summary>
		/// Retorna o nmero de comprovantes de crdito emitidos. 
		/// </summary>
		/// <param name="Comprovantes">Varivel STRING com o tamanho de 4 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ContadorComprovantesCreditoMFD(string Comprovantes);
		/// <summary>
		/// Retorna o nmero de cupons fiscais emitidos.
		/// </summary>
		/// <param name="CuponsEmitidos">Varivel STRING com o tamanho de 6 posies para receber a informao</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ContadorCupomFiscalMFD(string CuponsEmitidos);
		/// <summary>
		/// Retorna o nmero de vezes em que foi impressa a fita detalhe. 
		/// </summary>
		/// <param name="ContadorFita">Varivel STRING com o tamanho de 6 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ContadorFitaDetalheMFD(string ContadorFita);
		/// <summary>
		/// Retorna o nmero de operaes no fiscais canceladas. 
		/// </summary>
		/// <param name="OperacoesCanceladas">Varivel STRING com o tamanho de 4 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ContadorOperacoesNaoFiscaisCanceladasMFD(string OperacoesCanceladas);
		/// <summary>
		/// Retorna o nmero de relatrios gerenciais emitidos.
		/// </summary>
		/// <param name="Relatorios">Varivel STRING com o tamanho de 6 posies para receber a informao</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ContadorRelatoriosGerenciaisMFD (string Relatorios);
		/// <summary>
		/// Retorna o nmero de vezes em que os totalizadores no sujeitos ao ICMS foram usados.
		/// </summary>
		/// <param name="Contadores">Varivel STRING com 149 posies para receber as informaes. </param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ContadoresTotalizadoresNaoFiscaisMFD(string Contadores);
		/// <summary>
		/// Emite um cupom adicional com as informaes do COO e valor do cupom fiscal.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_CupomAdicionalMFD();
		/// <summary>
		/// Retorna os dados da impressora no momento da ltima reduo Z.
		/// </summary>
		/// <param name="DadosReducao">Varivel STRING com o tamanho de 1278 posies para receber os dados da ltima reduo.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_DadosUltimaReducaoMFD(string DadosReducao);
		/// <summary>
		/// Retorna a data e hora do ltimo documento armazenado na MFD no formato dd/mm/aa hh/mm/ss (sem barras e espao). 
		/// </summary>
		/// <param name="cDataHora">Varivel STRING com o tamanho de 12 posies para receber os dados.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_DataHoraUltimoDocumentoMFD(string cDataHora);
		/// <summary>
		/// Imprime a(s) forma(s) de pagamento e o(s) valor(es) pago(s) nessa forma.
		/// </summary>
		/// <param name="FormaPagamento">STRING com a forma de pagamento com no mximo 16 caracteres.</param>
		/// <param name="ValorFormaPagamento">STRING com o valor da forma de pagamento com at 14 dgitos.</param>
		/// <param name="Parcelas">STRING numrica entre 1 e 24 com o nmero de parcelas em que o pagamento ser realizado.</param>
		/// <param name="DescricaoFormaPagto">STRING com a descrio da forma de pagamento com no mximo 80 caracteres</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_EfetuaFormaPagamentoMFD(string FormaPagamento, string ValorFormaPagamento, string Parcelas, string DescricaoFormaPagto);
		/// <summary>
		/// Efetua o recebimento no fiscal.
		/// </summary>
		/// <param name="IndiceTotalizador">STRING com o ndice do Totalizador com at 2 dgitos para o recebimento.</param>
		/// <param name="ValorRecebimento">STRING com o Valor do recebimento com at 14 dgitos (duas casas decimais).</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_EfetuaRecebimentoNaoFiscalMFD(string IndiceTotalizador, string ValorRecebimento);
		/// <summary>
		/// Estorna os lanamentos de um comprovante de crdito ou dbito vinculado. Deve ser executado imediatamente aps a impresso do comprovante vinculado.
		/// </summary>
		/// <param name="CGC">STRING at 29 caracteres com o CGC ou CPF do cliente.</param>
		/// <param name="Nome">STRING at 30 caracteres com o nome do cliente.</param>
		/// <param name="Endereco">STRING at 80 caracteres com o endereo do cliente.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_EstornoNaoFiscalVinculadoMFD(string CGC, string Nome, string Endereco);
		/// <summary>
		/// Termina o fechamento do recebimento no fiscal. 
		/// </summary>
		/// <param name="Mensagem">STRING com a Mensagem promocional com at 490 caracteres.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_FechaRecebimentoNaoFiscalMFD(string Mensagem);
		/// <summary>
		/// Habilita e desabilita o retorno estendido na MFD. O retorno estendido  ACK, ST1, ST2 e ST3. Caso no seja habilitado, ser retornado apenas ACK, ST1 e ST2 como na impressora fiscal matricial MP-20 FI II ou MP-40 FI II.
		/// </summary>
		/// <param name="FlagRetorno">STRING com o valor um (1) para habilitar ou zero (0) para desabilitar o retorno estendido.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_HabilitaDesabilitaRetornoEstendidoMFD(string FlagRetorno);
		/// <summary>
		/// Imprime cheque na impressora MFD. Somente na impressora MP 6000.
		/// </summary>
		/// <param name="NumeroBanco">STRING com o Nmero do banco com 3 dgitos.</param>
		/// <param name="Valor">STRING com o Valor do cheque com at 14 dgitos.</param>
		/// <param name="Favorecido">STRING com o Favorecido com at 45 caracteres.</param>
		/// <param name="Cidade">STRING com a Cidade com at 27 caracteres.</param>
		/// <param name="Data">STRING com a Data no formato ddmmaa, dd/mm/aa, ddmmaaaa ou dd/mm/aaaa.</param>
		/// <param name="Mensagem">STRING com Comentrios at 120 caracteres. A mensagem ser impressa uma (1) linha aps a cidade caso no tenha sido indicada para impresso no verso.</param>
		/// <param name="ImpressaoVerso">STRING com o valor zero (0) para impresso da mensagem na frente do cheque e o valor um (1) para impresso no verso.</param>
		/// <param name="Linhas">STRING com um valor entre 0 e 35 com o nmero de linhas a serem saltadas antes da impresso da mensagem (s  utilizada na impresso da mensagem no verso).</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ImprimeChequeMFD(string NumeroBanco, string Valor, string Favorecido, string Cidade, string Data, string Mensagem, string ImpressaoVerso, string Linhas);
		/// <summary>
		/// Inicia o fechamento do cupom fiscal. Permite acrscimo e desconto no fechamento do cupom.
		/// </summary>
		/// <param name="AcrescimoDesconto">STRING que indica se haver acrscimo no cupom, desconto ou ambos. "A" para acrscimo, "D" para desconto e "X" para acrscimo e desconto.</param>
		/// <param name="TipoAcrescimoDesconto">STRING que indica se o acrscimo ou desconto  por valor ou por percentual. "$" para desconto por valor e "%" para percentual.</param>
		/// <param name="ValorAcrescimo">STRING com no mximo 14 dgitos para acrscimo por valor e 4 dgitos para acrscimo percentual.</param>
		/// <param name="ValorDesconto">STRING com no mximo 14 dgitos para desconto por valor e 4 dgitos para desconto percentual.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_IniciaFechamentoCupomMFD(string AcrescimoDesconto, string TipoAcrescimoDesconto, string ValorAcrescimo, string ValorDesconto);
		/// <summary>
		/// Inicia o fechamento do recebimento no fiscal. Permite acrscimo e desconto no fechamento do recebimento.
		/// </summary>
		/// <param name="AcrescimoDesconto">STRING que indica se haver acrscimo no cupom, desconto ou ambos. "A" para acrscimo, "D" para desconto e "X" para acrscimo e desconto.</param>
		/// <param name="TipoAcrescimoDesconto">STRING que indica se o acrscimo ou desconto  por valor ou por percentual. "$" para desconto por valor e "%" para percentual.</param>
		/// <param name="ValorAcrescimo">STRING com no mximo 14 dgitos para acrscimo por valor e 4 dgitos para acrscimo percentual.</param>
		/// <param name="ValorDesconto">STRING com no mximo 14 dgitos para desconto por valor e 4 dgitos para desconto percentual.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_IniciaFechamentoRecebimentoNaoFiscalMFD(string AcrescimoDesconto, string TipoAcrescimoDesconto, string ValorAcrescimo, string ValorDesconto);
		/// <summary>
		/// Retorna a incrio estadual do cliente cadatrada na impressora.
		/// </summary>
		/// <param name="InscricaoEstadual">Varivel STRING com o tamanho de 20 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_InscricaoEstadualMFD(string InscricaoEstadual);
		/// <summary>
		/// Retorna a incrio municipal do cliente cadatrada na impressora.
		/// </summary>
		/// <param name="InscricaoMunicipal">Varivel STRING com o tamanho de 20 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_InscricaoMunicipalMFD(string InscricaoMunicipal);
		/// <summary>
		/// Realiza a leitura do cdigo CMC7 do cheque. 
		/// </summary>
		/// <param name="CodigoCMC7">Varivel STRING com 36 posies para receber o cdigo CMC7.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_LeituraChequeMFD(string CodigoCMC7);
		/// <summary>
		/// Emite a leitura da memria fiscal da impressora por intervalo de datas.
		/// </summary>
		/// <param name="DataInicial">STRING para receber a Data inicial no formato ddmmaa, dd/mm/aa, ddmmaaaa ou dd/mm/aaaa.</param>
		/// <param name="DataFinal">STRING para receber a Data final no formato ddmmaa, dd/mm/aa, ddmmaaaa ou dd/mm/aaaa.</param>
		/// <param name="FlagLeitura">STRING com o valor "s" para leitura simplificada e "c" para leitura completa.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_LeituraMemoriaFiscalDataMFD(string DataInicial, string DataFinal, string FlagLeitura);
		/// <summary>
		/// Emite a leitura da memria fiscal da impressora por intervalo de redues.
		/// </summary>
		/// <param name="ReducaoInicial">Emite a leitura da memria fiscal da impressora por intervalo de redues</param>
		/// <param name="ReducaoFinal">STRING com o Nmero da reducao final com at 4 dgitos. </param>
		/// <param name="FlagLeitura">STRING com o valor "s" para leitura simplificada e "c" para leitura completa.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_LeituraMemoriaFiscalReducaoMFD(string ReducaoInicial, string ReducaoFinal, string FlagLeitura);
		/// <summary>
		/// Recebe os dados da memria fiscal por intervalo de datas pela serial e grava em arquivo texto.
		/// </summary>
		/// <param name="DataInicial">STRING para receber a Data inicial no formato ddmmaa, dd/mm/aa, ddmmaaaa ou dd/mm/aaaa.</param>
		/// <param name="DataFinal">STRING para receber a Data final no formato ddmmaa, dd/mm/aa, ddmmaaaa ou dd/mm/aaaa.</param>
		/// <param name="FlagLeitura">STRING com o valor "s" para leitura simplificada e "c" para leitura completa.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_LeituraMemoriaFiscalSerialDataMFD(string DataInicial, string DataFinal, string FlagLeitura);
		/// <summary>
		/// Recebe os dados da leitura da memria fiscal por intervalo de redues pela serial e grava em arquivo texto.
		/// </summary>
		/// <param name="ReducaoInicial">STRING com o Nmero da reducao inicial com at 4 dgitos.</param>
		/// <param name="ReducaoFinal">STRING com o Nmero da reducao final com at 4 dgitos.</param>
		/// <param name="FlagLeitura">STRING com o valor "s" para leitura simplificada e "c" para leitura completa.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_LeituraMemoriaFiscalSerialReducaoMFD(string ReducaoInicial, string ReducaoFinal, string FlagLeitura);
		/// <summary>
		/// Gera o relatrio "Mapa Resumo" referente ao movimento do dia. As informaes sero geradas no arquivo RETORNO.TXT no diretrio configurado no parmetro "path" do arquivo ini. O diretrio default configurado  o diretrio raiz (C:\).
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_MapaResumoMFD();
		/// <summary>
		/// Retorna a marca, o modelo e o tipo da impressora.
		/// </summary>
		/// <param name="Marca">Varivel STRING com 15 posies para receber a marca da impressora.</param>
		/// <param name="Modelo">Varivel STRING com 20 posies para receber o modelo.</param>
		/// <param name="Tipo">Varivel STRING com 7 posies para receber o tipo da impressora.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_MarcaModeloTipoImpressoraMFD(string Marca, string Modelo, string Tipo);
		/// <summary>
		/// Retorna o tempo em que a impressora emitiu documentos fiscais.
		/// </summary>
		/// <param name="Minutos">Varivel STRING com o tamanho de 4 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_MinutosEmitindoDocumentosFiscaisMFD(string Minutos);
		/// <summary>
		/// Programa Relatrio Gerencial. A impressora possui um relatrio default pr-programado: "Abertura de Caixa", no ndice "01".
		/// </summary>
		/// <param name="Indice">STRING numrica com valor entre 2 e 30 para o ndice do relatrio.</param>
		/// <param name="Descricao">STRING com at 17 caracteres com o nome do relatrio.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NomeiaRelatorioGerencialMFD(string Indice, string Descricao);
		/// <summary>
		/// Retorna o nmero de srie da impressora MFD. 
		/// </summary>
		/// <param name="NumeroSerie">Varivel STRING com o tamanho de 20 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NumeroSerieMFD(string NumeroSerie);
		/// <summary>
		/// Retorna o nmero de srie da memria de fita detalhe (MFD). 
		/// </summary>
		/// <param name="NumeroSerieMFD">Varivel STRING com o tamanho de 20 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_NumeroSerieMemoriaMFD(string NumeroSerieMFD);
		/// <summary>
		/// Retorna o percentual livre da Memria Fita Detalhe (MFD) no formato XX,XX% (com a virgula e o %). 
		/// </summary>
		/// <param name="cMemoriaLivre">Varivel STRING com o tamanho de 6 posies para receber os dados.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_PercentualLivreMFD(string cMemoriaLivre);
		/// <summary>
		/// Programa as formas de pagamento. 
		/// </summary>
		/// <param name="FormaPagto">STRING at 16 caracteres com a forma de pagamento.</param>
		/// <param name="OperacaoTef">STRING com 0 (zero) ou 1 (um) indicando se a forma de pagamento permite operao TEF ou no, onde: 
		///		<br></br>1 - permite operao TEF 
		///		<br></br>0 - no permite operao TEF. 
		///	</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ProgramaFormaPagamentoMFD(string FormaPagto, string OperacaoTef);
		/// <summary>
		/// Retorna o nmero de redues restantes na impressora.
		/// </summary>
		/// <param name="Reducoes">Varivel STRING com o tamanho de 4 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ReducoesRestantesMFD(string Reducoes);
		/// <summary>
		/// Reimprime o comprovante no fiscal vinculado. Ser executado, somente, se o comando for enviado imediatamente aps a impresso do comprovante.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ReimpressaoNaoFiscalVinculadoMFD();
		/// <summary>
		/// Gera o relatrio "Tipo 60 analtico" exigido pelo convnio de ICMS 85/2001. As informaes sero geradas no arquivo RETORNO.TXT no diretrio configurado no parmetro "path" do arquivo ini. O diretrio default  o diretrio raiz (C:\).
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_RelatorioTipo60AnaliticoMFD();
		/// <summary>
		/// L o retorno estendido da impressora (ACK, ST1, ST2 e ST3) referente ao ltimo comando enviado.
		/// </summary>
		/// <param name="ACK">Varivel inteira para receber o primeiro bytes de status da impressora.</param>
		/// <param name="ST1">Varivel inteira para receber o segundo bytes de status da impressora.</param>
		/// <param name="ST2">Varivel inteira para receber o terceiro bytes de status da impressora.</param>
		/// <param name="ST3">Varivel inteira para receber o quarto bytes de status da impressora.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_RetornoImpressoraMFD(ref int ACK, ref int ST1, ref int ST2, ref int ST3);
		/// <summary>
		/// Imprime a segunda via do comprovante no fiscal vinculado. Deve ser executada imediatamente aps a emisso da primeira via.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_SegundaViaNaoFiscalVinculadoMFD();
		/// <summary>
		/// Subtotaliza o cupom fiscal, ou seja, inicia o fechamento imprimindo o valor total do cupom.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_SubTotalizaCupomMFD();
		/// <summary>
		/// Subtotaliza o recebimento no fiscal (comprovante no fiscal no vinculado), ou seja, inicia o fechamento imprimindo o valor total do recebimento.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_SubTotalizaRecebimentoMFD();
		/// <summary>
		/// Retorna o quantidade de bytes livres na MFD.
		/// </summary>
		/// <param name="cMemoriaLivre">Varivel STRING com o tamanho de 10 posies para receber os dados.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_TotalLivreMFD(string cMemoriaLivre);
		/// <summary>
		/// Retorna o tamanho total da MFD em bytes.
		/// </summary>
		/// <param name="cTamanhoMFD">Varivel STRING com o tamanho de 10 posies para receber os dados.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_TamanhoTotalMFD(string cTamanhoMFD);
		/// <summary>
		/// Retorna o tempo em que a impressora est operacional.
		/// </summary>
		/// <param name="TempoOperacional">Varivel STRING com o tamanho de 4 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_TempoOperacionalMFD(string TempoOperacional);
		/// <summary>
		/// Totaliza o cupom fiscal habilitando o uso das formas de pagamento.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_TotalizaCupomMFD();
		/// <summary>
		/// Totaliza o recebimento no fiscal habilitando o uso das formas de pagamento.
		/// </summary>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_TotalizaRecebimentoMFD();
		/// <summary>
		/// Imprime as informaes do Relatrio Gerencial.
		/// </summary>
		/// <param name="Texto">STRING Texto a ser impresso no relatrio com at 618 caracteres. </param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_UsaRelatorioGerencialMFD(string Texto);
		/// <summary>
		/// Retorna o valor acumulado em uma determinada forma de pagamento
		/// </summary>
		/// <param name="Forma">Varivel STRING com at 16 posies com a descrio da Forma de Pagamento que deseja retornar o seu valor.</param>
		/// <param name="ValorForma">Varivel STRING com 14 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ValorFormaPagamentoMFD(string Forma, string ValorForma);
		/// <summary>
		/// Retorna o valor acumulado em um determinado totalizador no fiscal.
		/// </summary>
		/// <param name="Totalizador">Varivel STRING com at 19 posies com a descrio do Totalizador.</param>
		/// <param name="ValorTotalizador">Varivel STRING com 14 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_ValorTotalizadorNaoFiscalMFD(string Totalizador, string ValorTotalizador);
		/// <summary>
		/// Retorna o estado da impressora.
		/// </summary>
		/// <param name="ACK">Varivel inteira para receber o primeiro byte.</param>
		/// <param name="ST1">Varivel inteira para receber o segundo byte.</param>
		/// <param name="ST2">Varivel inteira para receber o terceiro byte.</param>
		/// <param name="ST3">Varivel inteira para receber o quarto byte.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaEstadoImpressoraMFD(ref int ACK, ref int ST1, ref int ST2, ref int ST3);
		/// <summary>
		/// Retorna as formas de pagamento e seus valores acumulados.
		/// </summary>
		/// <param name="FormasPagamento">Varivel string com 3016 posies para receber as formas programadas.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaFormasPagamentoMFD(string FormasPagamento);
		/// <summary>
		/// Retorna os recebimentos no fiscais no vinculados programados na impressora.
		/// </summary>
		/// <param name="Recebimentos">Varivel STRING com 1077 posies para receber as informaes.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaRecebimentoNaoFiscalMFD(string Recebimentos);
		/// <summary>
		/// Retorna os relatrios gerenciais programados e seus valores acumulados.
		/// </summary>
		/// <param name="Relatorios">Varivel STRING com 659 posies para receber as informaes.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaRelatorioGerencialMFD(string Relatorios);
		/// <summary>
		/// Retorna a descrio dos totalizadores no fiscais programados na impressora.
		/// </summary>
		/// <param name="Totalizadores">Varivel STRING com 599 posies para receber a descrio dos totalizadores no fiscais programados.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaTotalizadoresNaoFiscaisMFD(string Totalizadores);
		/// <summary>
		/// Retorna os totalizadores parciais da impressora.
		/// </summary>
		/// <param name="Totalizadores">Varivel STRING com o tamanho de 889 posies para receber os totalizadores parciais.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VerificaTotalizadoresParciaisMFD(string Totalizadores);
		/// <summary>
		/// Retorna a verso do firmware da impressora MFD.
		/// </summary>
		/// <param name="VersaoFirmware">Varivel STRING com o tamanho de 6 posies para receber a informao.</param>
		/// <returns>INTEIRO - Indica se a funo conseguiu enviar o comando para impressora.</returns>
		[DllImport("CONVECF.DLL")]public static extern int ECF_VersaoFirmwareMFD(string VersaoFirmware);
		#endregion
		
		
		// Fim da Declarao ///////////////////////////////////////////////////////////
		#endregion	

	}
}
